@extends('layouts.app')

@section('content')
    <!-- Page Header -->
    <div class="py-8 sm:py-12 md:py-16 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center">
                <h1 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-900 mb-4">Hasil Pemeriksaan</h1>
                <p class="text-lg sm:text-xl text-gray-600">Pilih jenis akses untuk melihat hasil pemeriksaan</p>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 sm:py-12 md:py-16 bg-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center">
                <!-- Selection Buttons -->
                <div class="flex flex-col sm:flex-row gap-4 sm:gap-6 justify-center items-center">
                    <!-- Patient Access Button -->
                    <a href="{{ route('results.patient.form') }}"
                        class="group relative inline-flex items-center justify-center px-6 sm:px-8 py-3 sm:py-4 text-base sm:text-lg font-medium text-white bg-[#192D50] hover:bg-[#192D50] focus:outline-none focus:ring-2 focus:ring-[#CBB4B0] focus:ring-offset-2 transition-all duration-200 transform hover:scale-105 shadow-lg hover:shadow-xl w-full sm:w-auto">
                        <div class="flex items-center">
                            <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                            <span>Akses Pasien</span>
                        </div>
                    </a>

                    <!-- Partner Access Button -->
                    <a href="{{ route('results.partner.form') }}"
                        class="group relative inline-flex items-center justify-center px-6 sm:px-8 py-3 sm:py-4 text-base sm:text-lg font-medium text-white bg-[#192D50] hover:bg-[#192D50] focus:outline-none focus:ring-2 focus:ring-[#CBB4B0] focus:ring-offset-2 transition-all duration-200 transform hover:scale-105 shadow-lg hover:shadow-xl w-full sm:w-auto">
                        <div class="flex items-center">
                            <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                                </path>
                            </svg>
                            <span>Akses Rekanan</span>
                        </div>
                    </a>
                </div>

                <!-- Information Cards -->
                <div class="mt-8 sm:mt-12 md:mt-16 grid grid-cols-1 md:grid-cols-2 gap-6 sm:gap-8">
                    <!-- Patient Access Info -->
                    <div
                        class="bg-white border border-gray-200 p-6 shadow-sm hover:shadow-md transition-shadow duration-200">
                        <div class="flex items-center mb-4">
                            <div class="w-12 h-12 bg-[#192D50] rounded-full flex items-center justify-center mr-4">
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                </svg>
                            </div>
                            <h3 class="text-xl font-semibold text-gray-900">Akses Pasien</h3>
                        </div>
                        <p class="text-gray-600 mb-4">
                            Untuk pasien yang ingin melihat hasil pemeriksaan pribadi.
                            Gunakan nomor rekam medis (MRN) dan password yang telah diberikan.
                        </p>
                        <ul class="text-sm text-gray-500 space-y-2">
                            <li class="flex items-center">
                                <svg class="w-4 h-4 text-[#CBB4B0] mr-2" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M5 13l4 4L19 7"></path>
                                </svg>
                                Masukkan MRN dan password
                            </li>
                            <li class="flex items-center">
                                <svg class="w-4 h-4 text-[#CBB4B0] mr-2" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M5 13l4 4L19 7"></path>
                                </svg>
                                Lihat hasil pemeriksaan
                            </li>
                            <li class="flex items-center">
                                <svg class="w-4 h-4 text-[#CBB4B0] mr-2" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M5 13l4 4L19 7"></path>
                                </svg>
                                Download file hasil
                            </li>
                        </ul>
                    </div>

                    <!-- Partner Access Info -->
                    <div
                        class="bg-white border border-gray-200 p-6 shadow-sm hover:shadow-md transition-shadow duration-200">
                        <div class="flex items-center mb-4">
                            <div class="w-12 h-12 bg-[#192D50] rounded-full flex items-center justify-center mr-4">
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                                    </path>
                                </svg>
                            </div>
                            <h3 class="text-xl font-semibold text-gray-900">Akses Rekanan</h3>
                        </div>
                        <p class="text-gray-600 mb-4">
                            Untuk perusahaan atau rekanan yang ingin melihat hasil pemeriksaan karyawan.
                            Gunakan kode akses yang telah diberikan.
                        </p>
                        <ul class="text-sm text-gray-500 space-y-2">
                            <li class="flex items-center">
                                <svg class="w-4 h-4 text-[#CBB4B0] mr-2" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M5 13l4 4L19 7"></path>
                                </svg>
                                Masukkan kode akses
                            </li>
                            <li class="flex items-center">
                                <svg class="w-4 h-4 text-[#CBB4B0] mr-2" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M5 13l4 4L19 7"></path>
                                </svg>
                                Lihat hasil karyawan
                            </li>
                            <li class="flex items-center">
                                <svg class="w-4 h-4 text-[#CBB4B0] mr-2" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M5 13l4 4L19 7"></path>
                                </svg>
                                Download laporan
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
